#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif
#include "conf.h"
#include "xmalloc.h"
#include "sys_deps.h"

struct type {
	char *str;
	int strlen;
	int type;
};

struct type types[] = {
	{"int", 3, TYPE_INT},
	{"oint", 4, TYPE_INT_OCTAL},
	{"bool", 4, TYPE_BOOL},
	{"str", 3, TYPE_STR},
	{"strarr", 6, TYPE_STR_ARRAY},
	{"enum", 4, TYPE_ENUM},
};
#define NTYPES (sizeof(types)/sizeof(struct type))

static int
chrexpand (char *str, int len)
{
	char *p;
	int off;

	p = str;
	off = 1;
	switch (p[1]) {
		case 'r':
			p[1] = '\r';
			break;
		case 'n':
			p[1] = '\n';
			break;
		case 't':
			p[1] = '\t';
			break;
		case 'a':
			p[1] = '\a';
			break;
		case 'b':
			p[1] = '\b';
			break;
		case 'v':
			p[1] = '\v';
			break;
		case 'f':
			p[1] = '\f';
			break;
		case 'x':
			while (isxdigit(p[off+1]) && off < 3)
				off++;
			p[off] = (char)strtoul(p+2, 0, 16);
			break;
		default:
			if (!isdigit(p[1]) || p[1] >= '8')
				break;
			while ((isdigit(p[off+1]) && p[off+1] < '8') && off < 3)
				off++;
			p[off] = (char)strtoul(p+2, 0, 8);
			break;
	}
	len -= off;
	memcpy(p, p+off, len);
	p[len] = 0;

	return off;
}

struct wanted *
conf_read (const char *filename, struct wanted *wanted_top)
{
	int fd, r, line, l, lookfor_type, comment, lastlinelen, nbs = 0, inquotes = 0;
	char buf[1024], *p, *xp, *yp, *zp, *lastlinep;
	struct wanted *wanted, *w, *last_wanted;
	int want_type = 0;
	unsigned int i;
	int type;
	struct enumarray *enumarr;
	unsigned int nenum;

	fd = SYS_open(filename, O_RDONLY, 0);
	if (fd < 0)
		return 0;
	line = 1;
	comment = 1;
	lookfor_type = 0;
	if (!wanted_top) {
		wanted_top = xmalloc(sizeof(struct wanted));
		memset(wanted_top, 0, sizeof(struct wanted));
	}
	last_wanted = w = wanted = wanted_top;
	lastlinep = p = buf;
	lastlinelen = 0;
	for (;;) {
		if (lastlinelen) {
			memcpy(buf, lastlinep, lastlinelen);
			w->begin = buf+(w->begin-lastlinep);
		}
		buf[lastlinelen]=0;
		if (sizeof(buf) == lastlinelen) {
			/* line is too big */
			/* fprintf(stderr, "line %d is too long\n", line); */
			break;
		}
		r = read(fd, buf+lastlinelen, sizeof(buf)-lastlinelen);
		if (r <= 0) {
			break;
		}
		r += lastlinelen;
		for (p = buf+r-1; p >= buf; p--) {
			if (*p == '\n') {
				lastlinep = p+1;
				lastlinelen = (buf+r) - lastlinep;
				goto foundnewline;
			}
		}
		lastlinep = buf;
		lastlinelen = r;
foundnewline:
		for (p = buf; p < lastlinep; p++) {
			/* count number of backslashes */
			if (*p == '\\') {
				if (*(p-1)=='\\')
					nbs++;
				else
					nbs = 1;
				r -= chrexpand(p, (buf+r)-p);
				continue;
			}
			nbs = 0;
			if (isspace(*p)) {
				if (*p == '\n') {
					line++;
					comment = 1;
					inquotes = 0;
					nbs = 0;
				}
				continue;
			}
			if (comment == 2)
				continue;
			if (*p == '#' && comment == 1) {
				comment = 2;
				continue;
			}
			if (*p == '"') {
				if (nbs%2!=1)
					inquotes = !inquotes;
					
			}
			if (w->type && *p == ';' && !inquotes && nbs%2!=1) {
				unsigned int len;

				len = p - w->begin;
				if (*(p-1) == '"')
					len--;
				if (w->begin[0] == '"') {
					w->begin++;
					len--;
				}
				w->valstr = xmalloc(len+1);
				memcpy(w->valstr, w->begin, len);
				w->valstr[len] = 0;
				w->flags |= WANTED_FLAG_ALLOCED_VALSTR;
				switch (w->type) {
					case 0:
						break;
					case TYPE_INT:
						w->val.i = strtol(w->valstr, 0, 0);
						break;
					case TYPE_INT_OCTAL:
						w->val.i = strtol(w->valstr, 0, 8);
						break;
					case TYPE_STR:
						w->val.s = w->valstr;
						break;
					case TYPE_STR_ARRAY:
						{
						char **arr;
						char *beg;
						unsigned int nstrs;
						int xinquotes, xnbs;

						arr = 0;
						nstrs = 0;
						xinquotes = 0;
						xnbs = 0;
						xp = w->begin-1;
						while (isspace(*xp)) xp++;
						for (beg = xp; xp <= p; xp++) {
#if 0
							/* count number of backslashes */
							if (*xp == '\\') {
								if (*(xp-1)=='\\')
									xnbs++;
								else
									xnbs = 1;
								continue;
							}
#endif
							xnbs = 0;
							if (*xp == '"') {
								if (xnbs%2!=1)
									xinquotes = !xinquotes;
								continue;
							}
							if ((*xp == ',' || *xp == ';') && !xinquotes && xnbs%2!=1) {
								if (*(xp-1) == '"')
									*(xp-1) = 0;
								*xp = 0;
								xp++;
								if (*beg == '"')
									beg++;
								arr = xrealloc(arr, sizeof(char *)*(nstrs+1));
								arr[nstrs] = xstrdup(beg);
								while (isspace(*xp)) xp++;
								beg = xp;
								xp--;
								nstrs++;
							}
						}
						arr = (char **)xrealloc(arr, sizeof(char *)*(nstrs+1));
						arr[nstrs] = 0;
						w->val.sa = arr;
						w->flags |= WANTED_FLAG_ALLOCED_VAL;
						}
						break;
					case TYPE_BOOL:
						if (isdigit(*(w->valstr)))
							w->val.i = strtol(w->begin, 0, 0);
						else if (!strcmp(w->begin, "true")
							 || !strcmp(w->valstr, "on")
							 || !strcmp(w->valstr, "ja")
							 || !strcmp(w->valstr, "yes")
							 || !strcmp(w->valstr, "si")
							 || !strcmp(w->valstr, "hai")
							 || !strcmp(w->valstr, "oui"))
							w->val.i = 1;
						else
							w->val.i = 0;
						break;
					case TYPE_ENUM:
						for (i = 0; i < w->nenum; i++) {
							if (!strcmp(w->valstr, w->enumarr[i].sym)) {
								w->val.i = i+1;
								break;
							}
						}
						break;
				}
				lookfor_type = 0;
				inquotes = 0;
				nbs = 0;
				continue;
			} else if (*p == '{') {
				want_type = 1;
				continue;
			} else if (*p == '}') {
				/*if (wanted->prev)*/
				w = wanted = wanted_top;
				want_type = 0;
				while (*(p+1) == ';')
					p++;
				continue;
			}
			if (lookfor_type)
				continue;
			type = 0;
			enumarr = 0;
			nenum = 0;
			if (want_type) {
				for (i = 0; i < NTYPES; i++) {
					l = types[i].strlen;
					if (!memcmp(p, types[i].str, l) && (isspace(*(p+l)) || *(p+l)=='{'))
						goto foundtype;
				}
				/* fprintf(stderr, "line %d: no such type\n", line); */
				goto nottype;
foundtype:
				type = types[i].type;
				p += types[i].strlen;
				/* this should be a new function */
				zp = p;
				if (type == TYPE_ENUM) {
					struct enumarray *en;
					int last_enum = 0;

					nenum = 0;
					xp = strchr(p, '{');
					if (!xp)
						goto notenum;
					xp++;
					while (*xp != '}' && !last_enum) {
						yp = strchr(xp, '=');
						if (!yp)
							goto notenum;
						yp++;
						zp = yp;
						while (*zp && (*zp != ',' && *zp != '}'))
							zp++;
						if (!*zp)
							goto notenum;
						if (*zp == '}')
							last_enum = 1;
						enumarr = xrealloc(enumarr, sizeof(struct enumarray)*(nenum+1));
						l = yp - xp - 1;
						en = &enumarr[nenum];
						*(yp-1)=0;
						en->sym = xstrdup(xp);
						*zp = 0;
						en->valstr = xstrdup(yp);
						nenum++;
						xp = zp + 1;
					}
					goto isenum;
notenum:
					type = TYPE_INT;
				}
isenum:
				if (type == TYPE_ENUM)
					p = zp + 1;
				while (isspace(*p))
					p++;
			}
nottype:
			for (w = wanted; w; w = w->next) {
				if (!w->str)
					continue;
				l = strlen(w->str);
				if (!memcmp(p, w->str, l) && (isspace(*(p+l)) || *(p+l)=='{')) {
					goto found;
				}
			
			}
			w = xmalloc(sizeof(struct wanted));
			memset(w, 0, sizeof(struct wanted));
			w->type = type;
			if (type == TYPE_ENUM) {
				w->enumarr = enumarr;
				w->nenum = nenum;
				w->flags |= WANTED_FLAG_ALLOCED_ENUMARR;
			}
found:
			l = 0;
			while (!isspace(p[l])&&p[l]!='{')
				 l++;
			if (!w->str) {
				w->str = xmalloc(l+1);
				memcpy(w->str, p, l);
				w->str[l] = 0;
			}
			if (w->type == 0) {
				if (!last_wanted->next)
					last_wanted->next = w;
				if (!w->prev)
					w->prev = last_wanted;
				last_wanted = w;
				if (w->subnext)
					wanted = w->subnext;
				else
					wanted = w;
				wanted->subtail = 0;
			} else {
				comment = 0;
				lookfor_type = 1;
				if (wanted->subtail) {
					if (!wanted->subtail->next) {
						wanted->subtail->next = w;
					}
					if (!w->prev)
						w->prev = wanted->subtail;
					wanted->subtail = w;
				} else {
					if (!wanted->subnext)
						wanted->subnext = w;
					wanted->subtail = w;
					if (!w->prev)
						w->prev = wanted;
				}
			}
			p += l;
			while (isspace(*p)) {
				if (*p == '\n')
					line++;
				p++;
			}
			w->begin = p;
			p--;
		}
	}
	close(fd);

	return wanted_top;
}

void
conf_wanted_to_config (void *__cfgp, struct wanted *wanted_top)
{
	unsigned int i;
	struct wanted *w, *ws;
	u_int8_t *cfgp, *p;
	char **sa, *sp;

	cfgp = (u_int8_t *)__cfgp;
	for (w = wanted_top->next; w; w = w->next) {
		for (ws = w->subnext; ws; ws = ws->next) {
			if (ws->soff < 0)
				continue;
			p = cfgp + ws->soff;
			switch (ws->type) {
				case TYPE_INT:
				case TYPE_INT_OCTAL:
				case TYPE_BOOL:
					*((int *)p) = ws->val.i;
					break;
				case TYPE_STR:
					sp = *((char **)p);
					if (sp)
						xfree(sp);
					if (ws->val.s)
						*((char **)p) = xstrdup(ws->val.s);
					else
						*((char **)p) = 0;
					break;
				case TYPE_STR_ARRAY:
					sa = *((char ***)p);
					if (sa) {
						for (i = 0; sa[i]; i++)
							xfree(sa[i]);
						xfree(sa);
					}
					i = 0;
					if (ws->val.sa)
						for (i = 0; ws->val.sa[i]; i++)
							;
					sa = xmalloc(sizeof(char *)*(i+1));
					if (ws->val.sa)
						for (i = 0; ws->val.sa[i]; i++)
							sa[i] = xstrdup(ws->val.sa[i]);
					sa[i] = 0;
					*((char ***)p) = sa;
					break;
				case TYPE_ENUM:
					*((int *)p) = ws->val.i;
					break;
				default:
					break;
			}
		}
	}
}

void
conf_freevars (struct wanted *wanted_top)
{
	unsigned int i;
	struct wanted *w, *ws, *next, *subnext;

	for (w = wanted_top->next; w; w = next) {
		for (ws = w->subnext; ws; ws = subnext) {
			if ((ws->flags & WANTED_FLAG_ALLOCED_VAL)) {
				switch (ws->type) {
					case TYPE_STR:
						if (ws->val.s && ws->val.s != ws->valstr)
							xfree(ws->val.s);
						ws->val.s = 0;
						break;
					case TYPE_STR_ARRAY:
						if (ws->val.sa) {
							for (i = 0; ws->val.sa[i]; i++)
								xfree(ws->val.sa[i]);
							xfree(ws->val.sa);
							ws->val.sa = 0;
						}
						break;
					default:
						break;
				}
			}
			if ((ws->flags & WANTED_FLAG_ALLOCED_VALSTR) && ws->valstr) {
				xfree(ws->valstr);
				ws->valstr = 0;
			}
			subnext = ws->next;
		}
		next = w->next;
	}
}

void
conf_free (struct wanted *wanted_top)
{
	unsigned int i;
	struct wanted *w, *ws, *next, *subnext;

	for (w = wanted_top->next; w; w = next) {
		for (ws = w->subnext; ws; ws = subnext) {
			if ((ws->flags & WANTED_FLAG_ALLOCED_VAL)) {
				switch (ws->type) {
					case TYPE_STR:
						if (ws->val.s)
							xfree(ws->val.s);
						ws->val.s = 0;
						break;
					case TYPE_STR_ARRAY:
						if (ws->val.sa) {
							for (i = 0; ws->val.sa[i]; i++)
								xfree(ws->val.sa[i]);
							xfree(ws->val.sa);
						}
						ws->val.sa = 0;
						break;
					default:
						break;
				}
			}
			if ((ws->flags & WANTED_FLAG_ALLOCED_ENUMARR) && ws->enumarr) {
				for (i = 0; i < ws->nenum; i++) {
					xfree(ws->enumarr[i].sym);
					xfree(ws->enumarr[i].valstr);
				}
				if (ws->enumarr)
					xfree(ws->enumarr);
			}
			ws->nenum = 0;
			if ((ws->flags & WANTED_FLAG_ALLOCED_VALSTR) && ws->valstr)
				xfree(ws->valstr);
			subnext = ws->next;
			if ((ws->flags & WANTED_FLAG_ALLOCED))
				xfree(ws);
		}
		next = w->next;
		if ((w->flags & WANTED_FLAG_ALLOCED))
			xfree(w);
	}
	xfree(wanted_top);
}
